import MirrorsByRegion from './mirrorsByRegion.js';
import { processUrl } from './processUrl.js';
function getDateTime() {
    const now = new Date();
    return now.toISOString().split('T')[0];
}
function printServer(mirror) {
}
export function generateMirrorlist(mirrors = []) {
    const httpMirrors = mirrors.filter(m => processUrl(m.url).mirrorListable);
    const mirrorsByRegion = new MirrorsByRegion(httpMirrors);
    const lines = [
        '##',
        '## Artix Linux repository mirrorlist',
        `## Generated on ${getDateTime()} by artix-mlg`,
        '##',
        '',
        '# Artix mirrors',
        '# Use rankmirrors(1) to get a list of the fastest mirrors for your location,',
        '# e.g.: rankmirrors -v -n 5 /etc/pacman.d/mirrorlist',
        '# Then put the resulting list on top of this file.',
        ''
    ];
    const printMirror = (m) => lines.push(`Server = ${m.url}`);
    const defaultMirrors = httpMirrors.filter(m => m.default);
    if (defaultMirrors.length) {
        lines.push('# Default mirrors');
        defaultMirrors.forEach(printMirror);
        lines.push('');
    }
    const globalMirrors = httpMirrors.filter(m => !m.country?.length);
    if (globalMirrors.length) {
        lines.push('## Worldwide');
        globalMirrors.forEach(printMirror);
        lines.push('');
    }
    mirrorsByRegion.printMirrors(lines);
    return lines.join('\n');
}
export default generateMirrorlist;
//# sourceMappingURL=mirrorlist.js.map