/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql.client;

import com.dbeaver.jdbc.driver.libsql.client.LibSqlExecutionResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class LibSqlClient {
    private static final Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    private final URL url;
    private final String authToken;
    private final ExecutorService clientExecutor;
    private String userAgent = "DBeaver LibSQL JDBC driver 1.1.2";
    private final HttpClient client;

    public LibSqlClient(URL url, String authToken) {
        this.url = url;
        this.authToken = authToken;
        this.clientExecutor = Executors.newSingleThreadExecutor();
        HttpClient.Builder builder = HttpClient.newBuilder().executor(this.clientExecutor).cookieHandler(new CookieManager());
        this.client = builder.build();
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public LibSqlExecutionResult execute(String stmt, Map<Object, Object> parameters) throws SQLException {
        return this.executeBatch(new String[]{stmt}, new Map[]{parameters})[0];
    }

    public LibSqlExecutionResult[] executeBatch(@NotNull String[] stmts, @Nullable Map<Object, Object>[] parameters) throws SQLException {
        StringWriter requestBuffer = new StringWriter();
        this.executeQuery(stmts, parameters, requestBuffer);
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.url.toURI()).version(HttpClient.Version.HTTP_1_1).header("Content-Type", "application/json").header("User-Agent", this.userAgent).POST(HttpRequest.BodyPublishers.ofString(requestBuffer.toString()));
        if (!CommonUtils.isEmpty((String)this.authToken)) {
            builder.header("Authorization", "Bearer " + this.authToken);
        }
        HttpResponse.BodyHandler readerBodyHandler = info -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
        HttpResponse httpResponse = this.client.send(builder.build(), readerBodyHandler);
        String responseBody = (String)httpResponse.body();
        StringReader isr = new StringReader(responseBody);
        try {
            Response[] response;
            if (responseBody.startsWith("[")) {
                response = (Response[])gson.fromJson((Reader)isr, Response[].class);
            } else {
                Response parsedResponse;
                try {
                    parsedResponse = (Response)gson.fromJson((Reader)isr, Response.class);
                }
                catch (JsonSyntaxException e) {
                    parsedResponse = new Response();
                    parsedResponse.error = responseBody;
                }
                response = new Response[]{parsedResponse};
            }
            LibSqlExecutionResult[] resultSets = new LibSqlExecutionResult[response.length];
            for (int i = 0; i < response.length; ++i) {
                if (!CommonUtils.isEmpty((String)response[i].error)) {
                    throw new SQLException(response[i].error);
                }
                resultSets[i] = response[i].results;
            }
            LibSqlExecutionResult[] libSqlExecutionResultArray = resultSets;
            isr.close();
            return libSqlExecutionResultArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        isr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    switch (httpResponse.statusCode()) {
                        case 401: {
                            throw new SQLException("Authentication required", e);
                        }
                        case 403: {
                            throw new SQLException("Access denied", e);
                        }
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    SQLException sqle = (SQLException)e;
                    throw sqle;
                }
                throw new SQLException(e);
            }
        }
    }

    public HttpURLConnection openSimpleConnection(String endpoint) throws IOException {
        Object baseURL = this.url.toString();
        if (!((String)baseURL).endsWith("/")) {
            baseURL = (String)baseURL + "/";
        }
        baseURL = (String)baseURL + endpoint;
        HttpURLConnection connection = (HttpURLConnection)new URL((String)baseURL).openConnection();
        connection.setRequestProperty("User-Agent", this.userAgent);
        return connection;
    }

    private void executeQuery(@NotNull String[] queries, @Nullable Map<Object, Object>[] parameters, @NotNull Writer os) throws IOException {
        JsonWriter jsonWriter = new JsonWriter(os);
        jsonWriter.beginObject();
        jsonWriter.name("statements");
        jsonWriter.beginArray();
        for (int i = 0; i < queries.length; ++i) {
            String stmt = queries[i];
            if (parameters != null && i < parameters.length && !CommonUtils.isEmpty(parameters[i])) {
                jsonWriter.beginObject();
                jsonWriter.name("q");
                jsonWriter.value(stmt);
                jsonWriter.name("params");
                if (this.isIndexedParams(parameters[i])) {
                    TreeMap<Integer, Object> paramTree = new TreeMap<Integer, Object>();
                    for (Map.Entry<Object, Object> entry : parameters[i].entrySet()) {
                        paramTree.put((Integer)entry.getKey(), entry.getValue());
                    }
                    jsonWriter.beginArray();
                    for (Map.Entry<Object, Object> value : paramTree.values()) {
                        LibSqlClient.serializeParameterValue(value, jsonWriter);
                    }
                    jsonWriter.endArray();
                } else {
                    jsonWriter.beginObject();
                    for (Map.Entry<Object, Object> param : parameters[i].entrySet()) {
                        jsonWriter.name(String.valueOf(param.getKey()));
                        LibSqlClient.serializeParameterValue(param.getValue(), jsonWriter);
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
                continue;
            }
            jsonWriter.value(stmt);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
        jsonWriter.flush();
    }

    private boolean isIndexedParams(Map<Object, Object> parameter) {
        if (!parameter.isEmpty()) {
            return parameter.keySet().iterator().next() instanceof Integer;
        }
        return false;
    }

    private static void serializeParameterValue(Object value, JsonWriter jsonWriter) throws IOException {
        if (value == null) {
            jsonWriter.nullValue();
        } else if (value instanceof Number) {
            Number nValue = (Number)value;
            jsonWriter.value(nValue);
        } else if (value instanceof Boolean) {
            Boolean bValue = (Boolean)value;
            jsonWriter.value(bValue);
        } else if (value instanceof String) {
            String strValue = (String)value;
            jsonWriter.value(strValue);
        } else {
            jsonWriter.value(value.toString());
        }
    }

    public void close() {
        this.clientExecutor.shutdown();
    }

    private static class Response {
        public String error;
        public LibSqlExecutionResult results;

        private Response() {
        }
    }
}

