/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.ClipboardData;
import org.jkiss.dbeaver.ui.CopyMode;
import org.jkiss.dbeaver.ui.IClipboardSource;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dnd.DatabaseObjectTransfer;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.BeanUtils;

public abstract class NavigatorHandlerCopyAbstract
extends AbstractHandler
implements IElementUpdater {
    NavigatorHandlerCopyAbstract() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Control focusControl = HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay().getFocusControl();
        if (focusControl != null && !(focusControl instanceof Composite)) {
            try {
                BeanUtils.invokeObjectMethod((Object)focusControl, (String)"copy");
                return null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        UIUtils.syncExec(() -> this.copySelection(workbenchWindow, activePart, selection));
        return null;
    }

    protected abstract CopyMode getCopyMode();

    private void copySelection(IWorkbenchWindow workbenchWindow, IWorkbenchPart activePart, ISelection selection) {
        ClipboardData clipboardData = new ClipboardData();
        IClipboardSource clipboardSource = (IClipboardSource)activePart.getAdapter(IClipboardSource.class);
        if (clipboardSource != null) {
            clipboardSource.addClipboardData(this.getCopyMode(), clipboardData);
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            if (!selection.isEmpty()) {
                ArrayList<DBNNode> selectedNodes = new ArrayList<DBNNode>();
                ArrayList<DBSObject> selectedObjects = new ArrayList<DBSObject>();
                ArrayList<String> selectedFiles = new ArrayList<String>();
                StringBuilder buf = new StringBuilder();
                for (Object object : structSelection) {
                    IFile file;
                    IPath location;
                    IResource iResource;
                    String objectValue = this.getObjectDisplayString(object);
                    if (objectValue == null) continue;
                    DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter(object, DBNNode.class);
                    DBSObject dbObject = null;
                    if (node instanceof DBNDatabaseNode) {
                        dbObject = ((DBNDatabaseNode)node).getObject();
                    }
                    if (dbObject == null) {
                        dbObject = (DBPNamedObject)RuntimeUtils.getObjectAdapter(object, DBPNamedObject.class);
                    }
                    if (node != null) {
                        selectedNodes.add(node);
                    }
                    if (node instanceof DBNResource && (iResource = ((DBNResource)node).getResource()) instanceof IFile && (location = (file = (IFile)iResource).getLocation()) != null) {
                        selectedFiles.add(location.makeAbsolute().toFile().getAbsolutePath());
                    }
                    if (dbObject != null) {
                        selectedObjects.add(dbObject);
                    }
                    if (!buf.isEmpty()) {
                        buf.append(GeneralUtils.getDefaultLineSeparator());
                    }
                    buf.append(objectValue);
                }
                if (!buf.isEmpty() && !clipboardData.hasTransfer((Transfer)TextTransfer.getInstance())) {
                    clipboardData.addTransfer((Transfer)TextTransfer.getInstance(), (Object)buf.toString());
                }
                if (!selectedNodes.isEmpty() && !clipboardData.hasTransfer((Transfer)TreeNodeTransfer.getInstance())) {
                    clipboardData.addTransfer((Transfer)TreeNodeTransfer.getInstance(), selectedNodes);
                }
                if (!selectedObjects.isEmpty() && !clipboardData.hasTransfer((Transfer)DatabaseObjectTransfer.getInstance())) {
                    clipboardData.addTransfer((Transfer)DatabaseObjectTransfer.getInstance(), selectedObjects);
                }
                if (!selectedFiles.isEmpty() && !clipboardData.hasTransfer((Transfer)FileTransfer.getInstance())) {
                    clipboardData.addTransfer((Transfer)FileTransfer.getInstance(), (Object)selectedFiles.toArray(new String[0]));
                }
            }
        }
        if (clipboardData.hasData()) {
            clipboardData.pushToClipboard(workbenchWindow.getShell().getDisplay());
        }
    }

    protected abstract String getObjectDisplayString(Object var1);

    protected abstract String getSelectionTitle(IStructuredSelection var1);

    public void updateElement(UIElement element, Map parameters) {
    }
}

