/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.commands;

import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;

public class MultipleResultsPerTabMenuContribution
extends ActionContributionItem {
    private static final ImageDescriptor multipleResultsPerTabImageFalse = DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_MULTIPLE_RESULTS_PER_TAB_FALSE);
    private static final ImageDescriptor multipleResultsPerTabImageTrue = DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_MULTIPLE_RESULTS_PER_TAB_TRUE);
    public static Image TRUE_IMAGE = multipleResultsPerTabImageFalse.createImage();
    public static Image FALSE_IMAGE = multipleResultsPerTabImageTrue.createImage();
    private static Action action = null;

    public MultipleResultsPerTabMenuContribution() {
        super((IAction)MultipleResultsPerTabMenuContribution.getContributedAction());
    }

    @NotNull
    private static Action getContributedAction() {
        return action != null ? action : (action = new MultipleResultsPerTabAction());
    }

    public static void syncWithEditor(@NotNull SQLEditor editor) {
        Action action = MultipleResultsPerTabMenuContribution.getContributedAction();
        boolean multipleResultsPerTab = editor.isMultipleResultsPerTabEnabled();
        action.setImageDescriptor(multipleResultsPerTab ? multipleResultsPerTabImageTrue : multipleResultsPerTabImageFalse);
        action.setChecked(multipleResultsPerTab);
    }

    private static class MultipleResultsPerTabAction
    extends CommandAction {
        public MultipleResultsPerTabAction() {
            super((IServiceLocator)PlatformUI.getWorkbench(), "org.jkiss.dbeaver.ui.editors.sql.multipleResultsPerTab");
        }
    }

    private static abstract class CommandAction
    extends Action {
        protected final Command command;

        public CommandAction(@NotNull IServiceLocator serviceLocator, String commandId) {
            String tooltip;
            String label;
            Command command = ActionUtils.findCommand((String)commandId);
            if (command == null) {
                throw new IllegalArgumentException("Failed to resolve command by id '" + commandId + "'");
            }
            try {
                label = command.getName();
                tooltip = command.getDescription();
            }
            catch (Throwable e) {
                String errorMessage = "Failed to resolve command parameters for unknown command '" + commandId + "'";
                throw new IllegalArgumentException(errorMessage, e);
            }
            this.command = command;
            ICommandImageService service = (ICommandImageService)serviceLocator.getService(ICommandImageService.class);
            this.setImageDescriptor(service.getImageDescriptor(command.getId(), 0, ICommandImageService.IMAGE_STYLE_DEFAULT));
            this.setDisabledImageDescriptor(service.getImageDescriptor(command.getId(), 1, ICommandImageService.IMAGE_STYLE_DEFAULT));
            this.setHoverImageDescriptor(service.getImageDescriptor(command.getId(), 2, ICommandImageService.IMAGE_STYLE_DEFAULT));
            this.setText(label);
            this.setDescription(tooltip);
            this.setToolTipText(tooltip);
        }

        public void run() {
            try {
                this.executeCommand();
            }
            catch (CommandException e) {
                DBWorkbench.getPlatformUI().showError("Command action error", "An error occurred during command action execution", (Throwable)e);
            }
        }

        protected void executeCommand() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
            StructuredSelection selection = new StructuredSelection();
            EvaluationContext context = new EvaluationContext(null, (Object)selection);
            context.addVariable("selection", (Object)selection);
            ExecutionEvent event = new ExecutionEvent(this.command, Collections.EMPTY_MAP, null, (Object)context);
            this.command.executeWithChecks(event);
        }
    }
}

