/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class InteractiveLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.INTERACTIVE_EXTERNAL_PORT_POSITIONER).addBefore(LayeredPhases.P2_LAYERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_PREPROCESSOR).addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_POSTPROCESSOR);
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive node layering", 1.0f);
        ArrayList<LayerSpan> currentSpans = Lists.newArrayList();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            double minx = node.getPosition().x;
            double maxx = minx + node.getSize().x;
            maxx = Math.max(minx + 1.0, maxx);
            ListIterator<LayerSpan> spanIter = currentSpans.listIterator();
            LayerSpan foundSpan = null;
            while (spanIter.hasNext()) {
                LayerSpan span = (LayerSpan)spanIter.next();
                if (span.start >= maxx) {
                    spanIter.previous();
                    break;
                }
                if (!(span.end > minx)) continue;
                if (foundSpan == null) {
                    span.nodes.add(node);
                    span.start = Math.min(span.start, minx);
                    span.end = Math.max(span.end, maxx);
                    foundSpan = span;
                    continue;
                }
                foundSpan.nodes.addAll(span.nodes);
                foundSpan.end = Math.max(foundSpan.end, span.end);
                spanIter.remove();
            }
            if (foundSpan != null) continue;
            foundSpan = new LayerSpan();
            foundSpan.start = minx;
            foundSpan.end = maxx;
            spanIter.add(foundSpan);
            foundSpan.nodes.add(node);
        }
        List<Layer> layers = layeredGraph.getLayers();
        int nextIndex = 0;
        for (LayerSpan span : currentSpans) {
            Layer layer = new Layer(layeredGraph);
            layer.id = nextIndex++;
            layers.add(layer);
            for (LNode node : span.nodes) {
                node.setLayer(layer);
                node.id = 0;
            }
        }
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.id != 0) continue;
            LinkedHashSet<LNode> shiftedNodes = this.checkNode(node, layeredGraph);
            while (!shiftedNodes.isEmpty()) {
                LNode nodeToCheck = (LNode)shiftedNodes.iterator().next();
                shiftedNodes.remove(nodeToCheck);
                shiftedNodes.addAll(this.checkNode(nodeToCheck, layeredGraph));
            }
        }
        ListIterator<Layer> layerIterator = layers.listIterator();
        while (layerIterator.hasNext()) {
            if (!layerIterator.next().getNodes().isEmpty()) continue;
            layerIterator.remove();
        }
        layeredGraph.getLayerlessNodes().clear();
        monitor.done();
    }

    private LinkedHashSet<LNode> checkNode(LNode node1, LGraph graph) {
        node1.id = 1;
        Layer layer1 = node1.getLayer();
        LinkedHashSet<LNode> shiftNodes = new LinkedHashSet<LNode>();
        for (LPort port : node1.getPorts(PortType.OUTPUT)) {
            for (LEdge edge : port.getOutgoingEdges()) {
                LNode node2 = edge.getTarget().getNode();
                if (node1 == node2) continue;
                Layer layer2 = node2.getLayer();
                if (layer2.id > layer1.id) continue;
                int newIndex = layer1.id + 1;
                if (newIndex == graph.getLayers().size()) {
                    newLayer = new Layer(graph);
                    newLayer.id = newIndex;
                    graph.getLayers().add(newLayer);
                    node2.setLayer(newLayer);
                } else {
                    newLayer = graph.getLayers().get(newIndex);
                    node2.setLayer(newLayer);
                }
                shiftNodes.add(node2);
            }
        }
        return shiftNodes;
    }

    private static class LayerSpan {
        private double start;
        private double end;
        private List<LNode> nodes = Lists.newArrayList();

        private LayerSpan() {
        }
    }
}

