/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.util;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;

public class SolrIdentifierValidator {
    static final Pattern identifierPattern = Pattern.compile("^(?!\\-)[\\._A-Za-z0-9\\-]+$");

    public static String validateName(IdentifierType type, String name) {
        if (!SolrIdentifierValidator.validateIdentifier(name)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, SolrIdentifierValidator.getIdentifierMessage(type, name));
        }
        return name;
    }

    public static String validateShardName(String shardName) {
        return SolrIdentifierValidator.validateName(IdentifierType.SHARD, shardName);
    }

    public static String validateCollectionName(String collectionName) {
        return SolrIdentifierValidator.validateName(IdentifierType.COLLECTION, collectionName);
    }

    public static String validateAliasName(String alias) {
        return SolrIdentifierValidator.validateName(IdentifierType.ALIAS, alias);
    }

    public static String validateCoreName(String coreName) {
        return SolrIdentifierValidator.validateName(IdentifierType.CORE, coreName);
    }

    private static boolean validateIdentifier(String identifier) {
        return identifier != null && identifierPattern.matcher(identifier).matches();
    }

    public static String getIdentifierMessage(IdentifierType identifierType, String name) {
        String typeStr = identifierType.toString().toLowerCase(Locale.ROOT);
        return "Invalid " + typeStr + ": [" + name + "]. " + typeStr + " names must consist entirely of periods, underscores, hyphens, and alphanumerics as well as not start with a hyphen.";
    }

    public static enum IdentifierType {
        SHARD,
        COLLECTION,
        CORE,
        ALIAS;

    }
}

