/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noggit.CharArr;
import org.noggit.JSONParser;

public class ObjectBuilder {
    final JSONParser parser;

    public static Object fromJSON(String json) throws IOException {
        JSONParser p = new JSONParser(json);
        return ObjectBuilder.getVal(p);
    }

    public static Object fromJSONStrict(String json) throws IOException {
        JSONParser p = new JSONParser(json);
        Object val = ObjectBuilder.getVal(p);
        ObjectBuilder.checkEOF(p);
        return val;
    }

    public static void checkEOF(JSONParser p) throws IOException {
        if (p.nextEvent() != 11) {
            throw p.err("Expecting single object only.");
        }
    }

    public static Object getVal(JSONParser parser) throws IOException {
        return new ObjectBuilder(parser).getVal();
    }

    public static Object getValStrict(JSONParser parser) throws IOException {
        Object val = ObjectBuilder.getVal(parser);
        ObjectBuilder.checkEOF(parser);
        return val;
    }

    public Object getValStrict() throws IOException {
        Object val = this.getVal();
        ObjectBuilder.checkEOF(this.parser);
        return val;
    }

    public ObjectBuilder(JSONParser parser) throws IOException {
        this.parser = parser;
        if (parser.lastEvent() == 0) {
            parser.nextEvent();
        }
    }

    public Object getVal() throws IOException {
        int ev = this.parser.lastEvent();
        switch (ev) {
            case 1: {
                return this.getString();
            }
            case 2: {
                return this.getLong();
            }
            case 3: {
                return this.getNumber();
            }
            case 4: {
                return this.getBigNumber();
            }
            case 5: {
                return this.getBoolean();
            }
            case 6: {
                return this.getNull();
            }
            case 7: {
                return this.getObject();
            }
            case 8: {
                return null;
            }
            case 9: {
                return this.getArray();
            }
            case 10: {
                return null;
            }
            case 11: {
                return null;
            }
        }
        return null;
    }

    public Object getString() throws IOException {
        return this.parser.getString();
    }

    public Object getLong() throws IOException {
        return this.parser.getLong();
    }

    public Object getNumber() throws IOException {
        CharArr num = this.parser.getNumberChars();
        String numstr = num.toString();
        double d = Double.parseDouble(numstr);
        if (!Double.isInfinite(d)) {
            return d;
        }
        return new BigDecimal(num.buf, num.start, num.size());
    }

    public Object getBigNumber() throws IOException {
        int ch;
        CharArr num = this.parser.getNumberChars();
        String numstr = num.toString();
        while ((ch = num.read()) != -1) {
            if (ch != 46 && ch != 101 && ch != 69) continue;
            return new BigDecimal(numstr);
        }
        return new BigInteger(numstr);
    }

    public Object getBoolean() throws IOException {
        return this.parser.getBoolean();
    }

    public Object getNull() throws IOException {
        this.parser.getNull();
        return null;
    }

    public Object newObject() throws IOException {
        return new LinkedHashMap();
    }

    public Object getKey() throws IOException {
        return this.parser.getString();
    }

    public void addKeyVal(Object map, Object key, Object val) throws IOException {
        ((Map)map).put(key, val);
    }

    public Object objectEnd(Object obj) {
        return obj;
    }

    public Object getObject() throws IOException {
        Object m = this.newObject();
        int ev;
        while ((ev = this.parser.nextEvent()) != 8) {
            Object key = this.getKey();
            ev = this.parser.nextEvent();
            Object val = this.getVal();
            this.addKeyVal(m, key, val);
        }
        return this.objectEnd(m);
    }

    public Object newArray() {
        return new ArrayList();
    }

    public void addArrayVal(Object arr, Object val) throws IOException {
        ((List)arr).add(val);
    }

    public Object endArray(Object arr) {
        return arr;
    }

    public Object getArray() throws IOException {
        Object arr = this.newArray();
        int ev;
        while ((ev = this.parser.nextEvent()) != 10) {
            Object val = this.getVal();
            this.addArrayVal(arr, val);
        }
        return this.endArray(arr);
    }
}

