/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import org.apache.sis.internal.feature.jts.GeometryTransform;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class GeometryCoordinateTransform
extends GeometryTransform {
    private final MathTransform transform;
    private double[] coordinates;

    GeometryCoordinateTransform(MathTransform mathTransform, GeometryFactory geometryFactory) {
        super(geometryFactory);
        this.transform = mathTransform;
    }

    @Override
    protected CoordinateSequence transform(CoordinateSequence coordinateSequence, int n) throws TransformException {
        int n2;
        int n3 = this.transform.getSourceDimensions();
        int n4 = this.transform.getTargetDimensions();
        int n5 = Math.max(n3, n4);
        int n6 = coordinateSequence.size();
        int n7 = Math.max(4, Math.min(100, n6));
        CoordinateSequence coordinateSequence2 = this.coordinateFactory.create(n6, n4);
        if (this.coordinates == null || this.coordinates.length / n5 < n7) {
            this.coordinates = new double[n7 * n5];
        }
        int n8 = 0;
        while ((n2 = Math.min(n6 - n8, n7)) > 0) {
            int n9;
            int n10 = n2 * n3;
            for (n9 = 0; n9 < n10; ++n9) {
                this.coordinates[n9] = coordinateSequence.getOrdinate(n8 + n9 / n3, n9 % n3);
            }
            this.transform.transform(this.coordinates, 0, this.coordinates, 0, n2);
            n10 = n2 * n4;
            for (n9 = 0; n9 < n10; ++n9) {
                coordinateSequence2.setOrdinate(n8 + n9 / n4, n9 % n4, this.coordinates[n9]);
            }
            n8 += n2;
        }
        return coordinateSequence2;
    }
}

